package edu.uky.ai.sl.ex;

import java.util.Random;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.data.DataPoint;
import edu.uky.ai.data.Feature;
import edu.uky.ai.data.Interval;
import edu.uky.ai.data.LabeledDataSet;
import edu.uky.ai.data.Numeric;
import edu.uky.ai.data.Value;
import edu.uky.ai.sl.Model;

public class RandomNumericModel implements Model {
	
	/** The serial version UID is used by Java's automatic serialization library. */
	private static final long serialVersionUID = 1L;
	
	/** The minimum class label value */
	private final Numeric min;
	
	/** The maximum class label value */
	private final Numeric max;
	
	/** The random number generator */
	private final Random random = new Random(0);

	/**
	 * Constructs a new model that picks a random value between the minimum
	 * and maximum values of a numeric class label.
	 * 
	 * @param data the labeled data set
	 */
	public RandomNumericModel(LabeledDataSet data) {
		// This model will only be used when the class label is numeric, so it
		// is safe to cast the class label.
		Feature<Numeric> classLabel = (Feature<Numeric>) data.labels;
		min = data.getMin(classLabel);
		max = data.getMax(classLabel);
	}
	
	@Override
	public Value classify(DataPoint point, SearchBudget budget) {
		// Choose a random number between the minimum and the maximum.
		double range = max.getNumber() - min.getNumber();
		double value = random.nextDouble() * range + min.getNumber();
		// Interval is one of two numeric data types (the other is ordinal).
		return new Interval(value);
	}
}